
#define DURATION_SEED 32  

/*****************************************************************************
*
*   Tone definition. Each tone are set up with a value which will give the 
*   right frequency when applied to a 16-bits timer with PWM. These values are based
*   on a CLKcpu running @ 1Mhz.
*
*   First find the frequency for all tones. 
*
*   Formula:    ToneX = Bf * 2^(ToneX/12)
*   
*   ToneX: the actual tone, e.g. C0 = 3
*   Bf: Basefrequency = 220Hz (A)
*
*       
*   E.g: For tone C0 this would be:     C0 = 220 * 2^(3/12)
*                                       C0 = 261,6256...
*
*   Now we must find which value to put in a 16-bits timer with PWM to achieve 
*   this frequency
*
*   Formula:    Timer value = 1Mhz / ToneHz / 2
*
*   E.g: For tone C0 this would be:     Timer value = 1000000 / 261,6256... / 2
*                                       Timer value = 1911
*
*   Set up a 16-bits timer to run at Phase/Freq-correct PWM, top value = ICR1,
*   set OC1A when upcounting, clear when downcounting.
*   
*****************************************************************************/

#define A   (char)(2273*0.625)        // tone 0
#define xA  (char)(2145*0.0625)
#define Ax  (char)(2145*0.0625)
#define B   (char)(2025*0.0625)
#define C0  (char)(1911*0.0625)
#define xC0 (char)(1804*0.0625)
#define Cx0 (char)(1804*0.0625)
#define D0  (char)(1703*0.0625)
#define xD0 (char)(1607*0.0625)
#define Dx0 (char)(1607*0.0625)
#define E0  (char)(1517*0.0625)
#define F0  (char)(1432*0.0625)
#define xF0 (char)(1351*0.0625)
#define Fx0 (char)(1351*0.0625)
#define G0  (char)(1275*0.0625)
#define xG0 (char)(1204*0.0625)
#define Gx0 (char)(1204*0.0625)
#define A0  (char)(1136*0.0625)
#define xA0 (char)(1073*0.0625)
#define Ax0 (char)(1073*0.0625)
#define B0  (char)(1012*0.0625)
#define C1  (char)(956*0.0625)
#define xC1 (char)(902*0.0625)
#define Cx1 (char)(902*0.0625)
#define D1  (char)(851*0.0625)
#define xD1 (char)(804*0.0625)
#define Dx1 (char)(804*0.0625)
#define E1  (char)(758*0.0625)
#define F1  (char)(716*0.0625)
#define xF1 (char)(676*0.0625)
#define Fx1 (char)(676*0.0625)
#define G1  (char)(638*0.0625)
#define xG1 (char)(602*0.0625)
#define Gx1 (char)(602*0.0625)
#define A1  (char)(568*0.0625)
#define xA1 (char)(536*0.0625)
#define Ax1 (char)(536*0.0625)
#define B1  (char)(506*0.0625)
#define C2  (char)(478*0.0625)
#define xC2 (char)(451*0.0625)
#define Cx2 (char)(451*0.0625)
#define D2  (char)(426*0.0625)
#define xD2 (char)(402*0.0625)
#define Dx2 (char)(402*0.0625)
#define E2  (char)(379*0.0625)
#define F2  (char)(356*0.0625)
#define xF2 (char)(338*0.0625)
#define Fx2 (char)(338*0.0625)
#define G2  (char)(319*0.0625)
#define xG2 (char)(301*0.0625)
#define Gx2 (char)(301*0.0625)
#define A2  (char)(284*0.0625)
#define xA2 (char)(268*0.0625)
#define Ax2 (char)(268*0.0625)
#define B2  (char)(253*0.0625)
#define C3  (char)(239*0.0625)
#define xC3 (char)(225*0.0625)
#define Cx3 (char)(225*0.0625)
#define D3  (char)(213*0.0625)
#define xD3 (char)(201*0.0625)
#define Dx3 (char)(201*0.0625)
#define E3  (char)(190*0.0625)
#define F3  (char)(179*0.0625)
#define xF3 (char)(169*0.0625)
#define Fx3 (char)(169*0.0625)
#define G3  (char)(159*0.0625)
#define xG3 (char)(150*0.0625)
#define Gx3 (char)(150*0.0625)
#define A3  (char)(142*0.0625)
#define xA3 (char)(134*0.0625)
#define Ax3 (char)(134*0.0625)
#define B3  (char)(127*0.0625)
#define C4  (char)(119*0.0625)
#define xC4 (char)(113*0.0625)
#define Cx4 (char)(113*0.0625)
#define D4  (char)(106*0.0625)
#define xD4 (char)(100*0.0625)
#define Dx4 (char)(100*0.0625)
#define E4  (char)(95*0.0625)
#define F4  (char)(89*0.0625)
#define xF4 (char)(84*0.0625)
#define Fx4 (char)(84*0.0625)
#define G4  (char)(80*0.0625)
#define xG4 (char)(75*0.0625)
#define Gx4 (char)(75*0.0625)
#define A4  (char)(71*0.0625)

#define P   1           // pause



/******************************************************************************
*
*   The tone definitions are duplicated to accept both upper and lower case
*
******************************************************************************/
#define a   (char)(2273*0.0625)
#define xa  (char)(2145*0.0625)
#define ax  (char)(2145*0.0625)
#define b   (char)(2024*0.0625)
#define c0  (char)(1911*0.0625)
#define xc0 (char)(1804*0.0625)
#define cx0 (char)(1804*0.0625)
#define d0  (char)(1703*0.0625)
#define xd0 (char)(1607*0.0625)
#define dx0 (char)(1607*0.0625)
#define e0  (char)(1517*0.0625)
#define f0  (char)(1432*0.0625)
#define xf0 (char)(1351*0.0625)
#define fx0 (char)(1351*0.0625)
#define g0  (char)(1275*0.0625)
#define xg0 (char)(1204*0.0625)
#define gx0 (char)(1204*0.0625)
#define a0  (char)(1136*0.0625)
#define xa0 (char)(1073*0.0625)
#define ax0 (char)(1073*0.0625)
#define b0  (char)(1012*0.0625)
#define c1  (char)(956*0.0625)
#define xc1 (char)(902*0.0625)
#define cx1 (char)(902*0.0625)
#define d1  (char)(851*0.0625)
#define xd1 (char)(804*0.0625)
#define dx1 (char)(804*0.0625)
#define e1  (char)(758*0.0625)
#define f1  (char)(716*0.0625)
#define xf1 (char)(676*0.0625)
#define fx1 (char)(676*0.0625)
#define g1  (char)(638*0.0625)
#define xg1 (char)(602*0.0625)
#define gx1 (char)(602*0.0625)
#define a1  (char)(568*0.0625)
#define xa1 (char)(536*0.0625)
#define ax1 (char)(536*0.0625)
#define b1  (char)(506*0.0625)
#define c2  (char)(478*0.0625)
#define xc2 (char)(451*0.0625)
#define cx2 (char)(451*0.0625)
#define d2  (char)(426*0.0625)
#define xd2 (char)(402*0.0625)
#define dx2 (char)(402*0.0625)
#define e2  (char)(379*0.0625)
#define f2  (char)(356*0.0625)
#define xf2 (char)(338*0.0625)
#define fx2 (char)(338*0.0625)
#define g2  (char)(319*0.0625)
#define xg2 (char)(301*0.0625)
#define gx2 (char)(301*0.0625)
#define a2  (char)(284*0.0625)
#define xa2 (char)(268*0.0625)
#define ax2 (char)(268*0.0625)
#define b2  (char)(253*0.0625)
#define c3  (char)(239*0.0625)
#define xc3 (char)(225*0.0625)
#define cx3 (char)(225*0.0625)
#define d3  (char)(213*0.0625)
#define xd3 (char)(201*0.0625)
#define dx3 (char)(201*0.0625)
#define e3  (char)(190*0.0625)
#define f3  (char)(179*0.0625)
#define xf3 (char)(169*0.0625)
#define fx3 (char)(169*0.0625)
#define g3  (char)(159*0.0625)
#define xg3 (char)(150*0.0625)
#define gx3 (char)(150*0.0625)
#define a3  (char)(142*0.0625)
#define xa3 (char)(134*0.0625)
#define ax3 (char)(134*0.0625)
#define b3  (char)(127*0.0625)
#define c4  (char)(119*0.0625)
#define xc4 (char)(113*0.0625)
#define cx4 (char)(113*0.0625)
#define d4  (char)(106*0.0625)
#define xd4 (char)(100*0.0625)
#define dx4 (char)(100*0.0625)
#define e4  (char)(95*0.0625)
#define f4  (char)(89*0.0625)
#define xf4 (char)(84*0.0625)
#define fx4 (char)(84*0.0625)
#define g4  (char)(80*0.0625)
#define xg4 (char)(75*0.0625)
#define gx4 (char)(75*0.0625)
#define a4  (char)(71*0.0625)

#define p   1

static char Tone = 0;
static char Tempo;
static char Duration = 0;
flash char *pSong;
char Do_PLAY;

#define sound_is_play (Do_PLAY==1)

void sound_init(){



DDRD.7=1;
PORTD.7=1;// SP OFF

}

void stop_sound(void){
                Do_PLAY=0;
                TCCR2=0;
                PORTD.7=1;              // set OC1A high
}

void play_sound(flash char *Sound){
pSong = Sound;
stop_sound();
// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: 31.250 kHz
// Mode: CTC top=OCR2
// OC2 output: Toggle on compare match
ASSR=0x00;
TCCR2=0x1E;
TCNT2=0x00;
OCR2=0x00;
Do_PLAY=1;
}




void paly_sound_key(flash char *song){
//PUSH ALL REGISTER FOR SOUND
char Tone_temp = Tone;
char Tempo_temp = Tempo;
char Duration_temp = Duration;
flash char *pSong_tmep=pSong;
char Do_PLAY_temp=Do_PLAY;
char TCCR2_temp=TCCR2;
char TCNT2_tmep=TCNT2;
char OCR2_tmep=OCR2;
     if(Do_PLAY==1){
        return;
        }
    TCCR2=0;
    Do_PLAY=0;
    pSong=song;
    Tone=0;
    Duration=0;
    Do_PLAY=1;
    TCCR2 = 0x1E;
    while(Do_PLAY==1);// Waiting For Stop Sound
     
    
//POP ALL REGISTER FOR SOUND
Tone = Tone_temp;
Tempo = Tempo_temp;
Duration = Duration_temp;
pSong = pSong_tmep;
Do_PLAY=Do_PLAY_temp;    
TCCR2 = TCCR2_temp;
TCNT2 =TCNT2_tmep;
OCR2 =OCR2_tmep;
}


void Play_Tune(void)
{
    unsigned char temp_tone;    // mt 200301
    char loop;
    if(Do_PLAY==1){
    
    if(!Tone)
    {
        Duration = 0;   
        // mt Tempo = *(pSong + 0);
        Tempo = *(pSong + 0);
        Tone = 1;   //Start the song from the beginning
    }
    
    if(!Tempo)
    {
        if(Duration)        // Check if the lenght of the tone has "expired"
        {   
          Duration--;
          
        }          
        else if(*(pSong + Tone))  // If not the end of the song
        {
            // mt: Duration = ( DURATION_SEED / *(pSong + Tone) );  // store the duration
            Duration = ( DURATION_SEED / *(pSong + Tone) );  // store the duration
        
            Tone++;                     // point to the next tone in the Song-table        

            temp_tone= *(pSong + Tone); // mt 200301
            // mt: if( (*(pSong + Tone) == p) | (*(pSong + Tone) == P) ) // if pause
            // if( (pgm_read_word(pSong + Tone) == p) | (pgm_read_word(pSong + Tone) == P) ) // if pause
            if( (temp_tone == p) | (temp_tone == P) ) // if pause
               TCCR2=0x00; ;//cbi(TCCR1B, CS10);             // stop Timer1, prescaler(1)    
            else 
               TCCR2=0x1E ;//sbiBF(TCCR1B, CS10);             // start Timer1, prescaler(1)  
                
            //cli(); // mt __disable_interrupt();
            
            // mt temp_hi = *(pSong + Tone);      // read out the PWM-value
            // temp_hi = pgm_read_word(pSong + Tone);      // read out the PWM-value
          
                
            TCNT2 = 0;                     // reset TCNT1H/L
        
            OCR2 =temp_tone;            // mt 200301
            // mt: ICR1L = *(pSong + Tone);        
			// ICR1L = pgm_read_word(pSong + Tone);
			
            
            //sei(); // mt: __enable_interrupt();
            
            Tone++;                     // point to the next tone in the Song-table
        }
        else    // the end of song
        {
           Tone++;         // point to the next tone in the Song-table        
            
            // mt: loop = *(pSong + Tone); // get the byte that tells if the song should loop or not
			loop = *(pSong + Tone); // get the byte that tells if the song should loop or not
            
            if( loop )  
            {
                Tone = 1;
            }
            else        // if not looping the song
            {    
                Do_PLAY=0;
                TCCR2=0;
                PORTD.7=1;              // set OC1A high
            }
                    
        }
        
        // mt: Tempo = *(pSong + 0);
		Tempo = *(pSong + 0);
    }
    else
        Tempo--;
    }
} 